#ifndef __IToolTip__
#define __IToolTip__

#include <MathTools/CPoint.hpp>
#include <Basics/CString.hpp>

//	===========================================================================

using Exponent::MathTools::CPoint;
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @interface IToolTip IToolTip.hpp
			 * @brief Interface to a tool tip window
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IToolTip.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			interface IToolTip
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IToolTip() { }
				
				/**
				 * Destruction
				 */
				virtual ~IToolTip() { }

//	===========================================================================

				/**
				 * Show the tool tip at a specific location
				 * @param where Where to position the tooltip
				 */
				virtual void showToolTip(const CPoint &where) = 0;

				/**
				 * Hide the tool tip
				 */
				virtual void hideToolTip() = 0;

				/**
				 * Is the tool tip visible?
				 * @retval bool TRue if the user can see the tool tip, false otherwise
				 */
				virtual bool toolTipIsVisible() const = 0;

//	===========================================================================

				/**
				 * Set the text to be displayed
				 * @param string The string to display
				 */
				virtual void setToolTipText(const CString &string) = 0;

//	===========================================================================

				/**
				 * Move the tool tip to a specific location
				 * @param where The position to move to
				 */
				virtual void moveTo(const CPoint &where) = 0;

//	===========================================================================

			};
		}
	}
}
#endif	// End of IToolTip.hpp